/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.auiml.databeans.profile;

import com.ibm.hsc.client.PICECDataBean;
import com.ibm.hsc.client.PILPARDataBean;
import com.ibm.hsc.client.PILPARProfileDataBean;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.util.NameFormat;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.DataBean;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.UserTaskManager;
import com.ibm.ui.framework.ValueDescriptor;
import java.util.Hashtable;
import java.util.Vector;
import org.snia.wbem.cim.UnsignedInt8;

public class PILparProfGenBean
implements DataBean {
    private static final String PROFILE_BUNDLE = "PIHSCCommonBundle";
    private static final String InvalidPartName = HSCResourceBundleUtil.getMessage("PIHSCCommonBundle", "INVALID_PARTITION_NAME");
    private static final String And = HSCResourceBundleUtil.getMessage("PIHSCCommonBundle", "AND");
    private String m_sSystemName;
    private int m_iPartitionNumber;
    private String m_sPartitionName;
    private String[] m_sPartitionTypeSelection;
    private String[] m_sInWLMSelection;
    private int m_iWlmGroupID;
    private ValueDescriptor[] m_vdGroupID;
    private String m_sProfileName;
    private String[] m_sProfileTypeSelection;
    private UserTaskManager m_utm;
    private PICECDataBean m_cimCecBean;
    private PILPARDataBean m_cimLparBean;
    private PILPARProfileDataBean m_cimProfBean;
    private Hashtable m_lparNamesAndIds;
    private Vector m_profNames;
    private String m_sOSType = "";
    private final int MIN_NAME_LENGTH = 1;
    private final int MAX_NAME_LENGTH = 31;
    private final int MIN_WLM_NUM = 0;
    private final int MAX_WLM_NUM = Short.MAX_VALUE;

    public PILparProfGenBean(PICECDataBean pICECDataBean, PILPARDataBean pILPARDataBean, PILPARProfileDataBean pILPARProfileDataBean, Hashtable hashtable, Vector vector) {
        this.m_cimCecBean = pICECDataBean;
        this.m_cimLparBean = pILPARDataBean;
        this.m_cimProfBean = pILPARProfileDataBean;
        this.m_lparNamesAndIds = hashtable;
        this.m_profNames = vector;
    }

    public PILparProfGenBean(PICECDataBean pICECDataBean, PILPARProfileDataBean pILPARProfileDataBean, Hashtable hashtable, Vector vector) {
        this.m_cimCecBean = pICECDataBean;
        this.m_cimLparBean = null;
        this.m_cimProfBean = pILPARProfileDataBean;
        this.m_lparNamesAndIds = hashtable;
        this.m_profNames = vector;
    }

    public String getOSTypeLabel() {
        return this.m_sOSType;
    }

    public void setOSTypeLabel(String string) {
        if (string != null) {
            this.m_sOSType = string;
        }
    }

    public void setSystemName(String string) throws IllegalUserDataException {
        this.m_sSystemName = string;
    }

    public String getSystemName() {
        return this.m_sSystemName;
    }

    public void setPartitionNumber(int n) throws IllegalUserDataException {
        this.m_iPartitionNumber = n;
        if (this.m_utm != null) {
            this.m_utm.refreshElement("ProfGen.PartitionNumber");
        }
    }

    public int getPartitionNumber() {
        return this.m_iPartitionNumber;
    }

    public String getPartitionID() {
        return "" + this.m_iPartitionNumber;
    }

    public void setPartitionName(String string) throws IllegalUserDataException {
        string = string.trim();
        if (this.m_lparNamesAndIds == null || this.m_lparNamesAndIds.containsValue(string)) {
            // empty if block
        }
        this.m_sPartitionName = string;
        if (this.m_cimProfBean != null) {
            this.m_cimProfBean.setName(this.m_sPartitionName);
        }
        if (this.m_utm != null) {
            this.m_utm.refreshElement("ProfGen.PartitionName");
        }
    }

    public String getPartitionName() {
        return this.m_sPartitionName;
    }

    public void setPartitionTypeSelection(String[] stringArray) throws IllegalUserDataException {
        this.m_sPartitionTypeSelection = stringArray;
        if (this.m_sPartitionTypeSelection[0].equals("LparGen.RPA")) {
            this.m_utm.setEnabled("ProfGen.FullSysLeadIn", true);
            this.m_utm.setEnabled("ProfGen.Checkbox1", true);
            this.m_cimProfBean.setOsType(new UnsignedInt8(1));
        } else if (this.m_sPartitionTypeSelection[0].equals("LparGen.OS400")) {
            this.m_cimProfBean.setOsType(new UnsignedInt8(129));
            if (this.m_cimCecBean.isOS400ProcCapacityLimited()) {
                this.m_utm.setEnabled("ProfGen.FullSysLeadIn", false);
                this.m_utm.setEnabled("ProfGen.Checkbox1", false);
            } else {
                this.m_utm.setEnabled("ProfGen.FullSysLeadIn", true);
                this.m_utm.setEnabled("ProfGen.Checkbox1", true);
            }
        } else if (this.m_sPartitionTypeSelection[0].equals("LparGen.IOServer")) {
            this.m_utm.setEnabled("ProfGen.FullSysLeadIn", true);
            this.m_utm.setEnabled("ProfGen.Checkbox1", true);
            this.m_cimProfBean.setOsType(new UnsignedInt8(65));
        }
    }

    public String[] getPartitionTypeSelection() {
        return this.m_sPartitionTypeSelection;
    }

    public void setInWLMSelection(String[] stringArray) throws IllegalUserDataException {
        this.m_sInWLMSelection = stringArray;
    }

    public String[] getInWLMSelection() {
        return this.m_sInWLMSelection;
    }

    public void setWlmGroupID(int n) throws IllegalUserDataException {
        this.m_iWlmGroupID = n;
    }

    public int getWlmGroupID() {
        return this.m_iWlmGroupID;
    }

    public void setProfileName(String string) throws IllegalUserDataException {
        this.m_sProfileName = string = string.trim();
        if (this.m_cimProfBean != null) {
            this.m_cimProfBean.setName(string);
        }
    }

    public String getProfileName() {
        return this.m_sProfileName;
    }

    public void setProfileTypeSelection(String[] stringArray) throws IllegalUserDataException {
        this.m_sProfileTypeSelection = stringArray;
        if (this.m_cimProfBean != null) {
            if (this.m_sProfileTypeSelection[0].equals("CustomPick")) {
                this.m_cimProfBean.setProfileType(new UnsignedInt8(0));
            } else {
                this.m_cimProfBean.setProfileType(new UnsignedInt8(1));
            }
        }
    }

    public String[] getProfileTypeSelection() {
        return this.m_sProfileTypeSelection;
    }

    public void setUserTaskManager(UserTaskManager userTaskManager) throws IllegalUserDataException {
        this.m_utm = userTaskManager;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() throws IllegalUserDataException {
        this.verifyProfPan();
    }

    public void load() {
        int n;
        String string;
        this.m_sSystemName = this.m_cimCecBean != null ? this.m_cimCecBean.getUserDefinedName() : " ";
        if (this.m_cimProfBean != null) {
            string = this.m_cimProfBean.getLparId();
            n = string.indexOf(42);
            if (n != -1) {
                string = string.substring(0, n);
            }
            this.m_iPartitionNumber = Integer.parseInt(string);
            this.m_cimProfBean.setLparId(string);
            this.m_sPartitionName = this.m_lparNamesAndIds != null ? (String)this.m_lparNamesAndIds.get(string) : " ";
            this.m_sProfileName = this.m_cimProfBean.getName();
        } else {
            this.m_iPartitionNumber = 1;
            this.m_sPartitionName = " ";
            this.m_sProfileName = " ";
        }
        string = this.m_cimProfBean.getOsType();
        if (string == null) {
            this.m_sPartitionTypeSelection = new String[]{"LparGen.RPA"};
            this.m_cimProfBean.setOsType(new UnsignedInt8(1));
        } else {
            n = this.m_cimProfBean.getOsType().intValue();
            if (n == 1) {
                this.m_sPartitionTypeSelection = new String[]{"LparGen.RPA"};
                this.m_sOSType = HSCResourceBundleUtil.getMessage("ProfileBundle", "OSTYPE_AIX_LINUX");
            } else if (n == 129) {
                this.m_sPartitionTypeSelection = new String[]{"LparGen.OS400"};
                this.m_sOSType = HSCResourceBundleUtil.getMessage("ProfileBundle", "OSTYPE_OS400");
            } else if (n == 65) {
                this.m_sPartitionTypeSelection = new String[]{"LparGen.IOServer"};
                this.m_sOSType = HSCResourceBundleUtil.getMessage("ProfileBundle", "OSTYPE_RPA_IO_SERVER");
            }
        }
        this.m_sInWLMSelection = new String[]{"LparGen2.NO"};
        this.m_iWlmGroupID = 0;
        this.m_sProfileTypeSelection = new String[]{"ProfGen.CustomPick"};
    }

    public void save() {
        this.m_cimProfBean.setLparId(String.valueOf(this.m_iPartitionNumber) + "*" + this.m_cimCecBean.getInternalName());
    }

    public void verifyLparPan() throws IllegalUserDataException {
        int n;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        if (this.m_sPartitionName == null) {
            this.m_sPartitionName = "";
        }
        if ((n = this.m_sPartitionName.trim().length()) < 1 || n > 31) {
            string2 = HSCResourceBundleUtil.getMessage(PROFILE_BUNDLE, "INVALID_PARTITION_NAME", "NLS_MESSAGE_NOT_FOUND", new Object[]{String.valueOf(1), String.valueOf(31)});
            throw new IllegalUserDataException(string2);
        }
        NameFormat nameFormat = new NameFormat();
        nameFormat.parse(this.m_sPartitionName);
        if (this.m_lparNamesAndIds != null && this.m_lparNamesAndIds.containsValue(this.m_sPartitionName)) {
            string = HSCResourceBundleUtil.getMessage(PROFILE_BUNDLE, "INVALID_LPAR_NAME", "NLS_MESSAGE_NOT_FOUND", new Object[]{this.m_sPartitionName});
            throw new IllegalUserDataException(string);
        }
        if (this.m_lparNamesAndIds != null && this.m_lparNamesAndIds.containsKey(String.valueOf(this.m_iPartitionNumber))) {
            string3 = HSCResourceBundleUtil.getMessage(PROFILE_BUNDLE, "INVALID_LPAR_NUMBER", "NLS_MESSAGE_NOT_FOUND", new Object[]{String.valueOf(this.m_iPartitionNumber)});
            throw new IllegalUserDataException(string3);
        }
        if (this.m_iPartitionNumber < 1 || this.m_iPartitionNumber > this.m_cimCecBean.getNumberOfLPARSlots().intValue()) {
            string4 = HSCResourceBundleUtil.getMessage(PROFILE_BUNDLE, "INVALID_PART_RANGE", "NLS_MESSAGE_NOT_FOUND", new Object[]{String.valueOf(1), this.m_cimCecBean.getNumberOfLPARSlots().toString()});
            throw new IllegalUserDataException(string4);
        }
        if (this.m_iWlmGroupID < 0 || this.m_iWlmGroupID > Short.MAX_VALUE) {
            string5 = HSCResourceBundleUtil.getMessage(PROFILE_BUNDLE, "INVALID_WLM_RANGE", "NLS_MESSAGE_NOT_FOUND", new Object[]{String.valueOf(0), String.valueOf(Short.MAX_VALUE)});
            throw new IllegalUserDataException(string5);
        }
    }

    public void verifyProfPan() throws IllegalUserDataException {
        String string = null;
        String string2 = null;
        if (this.m_sProfileName == null) {
            this.m_sProfileName = "";
        }
        int n = this.m_sProfileName.trim().length();
        string = HSCResourceBundleUtil.getMessage(PROFILE_BUNDLE, "INVALID_PROF_NAME", "NLS_MESSAGE_NOT_FOUND", new Object[]{String.valueOf(1), String.valueOf(31)});
        if (n < 1 || n > 31) {
            throw new IllegalUserDataException(string);
        }
        NameFormat nameFormat = new NameFormat();
        nameFormat.parse(this.m_sProfileName);
        if (this.m_profNames != null && this.m_profNames.contains(this.m_sProfileName)) {
            string2 = HSCResourceBundleUtil.getMessage(PROFILE_BUNDLE, "PROFNAME_USED", "NLS_MESSAGE_NOT_FOUND", new Object[]{this.m_sProfileName});
            throw new IllegalUserDataException(string2);
        }
    }
}

